# System Restructuring - Todo List

## Phase 1: Database Cleanup ✅ COMPLETED
- [x] Create migration scripts to remove tax tables
- [x] Create migration scripts to remove product_variants table and all variant_id foreign keys
- [x] Update sales/sale_items to remove tax fields and variant_id
- [x] Update products to remove tax references and variant relationships
- [x] Update BOM structure (remove fg_variant_id, use fg_product_id)
- [x] Update payments to support new methods (CASH/CARD/MPESA)
- [x] Add low_stock_threshold field to products/inventory
- [x] Update all Sequelize models
- [x] Sync database from updated models

## Phase 2: Backend API Updates 🔄 IN PROGRESS

### 2.1 Remove Tax Services/Modules
- [ ] Remove `modules/taxes/` directory
- [ ] Remove tax-related API endpoints
- [ ] Remove tax middleware/helpers
- [ ] Update error handling to remove tax references

### 2.2 Update Products Module
- [ ] Remove tax references from product service
- [ ] Remove variant functionality completely
- [ ] Ensure UUID generation for **FG products ONLY** (RM products don't need UUIDs)
- [ ] Add low stock threshold management endpoints
- [ ] Update product validation to remove tax/variant checks

### 2.3 Restructure BOM Module
- [ ] Update BOM service to use `fg_product_id` instead of `fg_variant_id`
- [ ] Add Category and Type fields to BOM structure
- [ ] Update BOM creation to support multiple RM items (Fabric, Buttons, Zipper, Lining, Elastic)
- [ ] Update BOM validation logic
- [ ] Update BOM item types (FABRIC, BUTTONS, ZIPPER, LINING, ELASTIC)

### 2.4 Update Production Module
- [ ] Remove tax calculations
- [ ] Remove variant references (use `fg_product_id`)
- [ ] Update to match new BOM structure
- [ ] Ensure UUID generation for FG output only (RM products don't need UUIDs)
- [ ] Update production order confirmation logic

### 2.5 Update Sales Module (POS)
- [ ] Remove customer selection/registration
- [ ] Remove tax calculations
- [ ] Remove variant references
- [ ] Update payment method handling
- [ ] Ensure sales work with walk-in customers only

### 2.6 Update Payments Module
- [ ] Support: CASH, CARD, MPESA
- [ ] Default to CASH only for now
- [ ] Update payment processing logic
- [ ] Update payment validation

### 2.7 Update Discounts Module
- [ ] Support per-product discounts
- [ ] Support per-group discounts
- [ ] Remove tax-related discount calculations
- [ ] Update discount validation

### 2.8 Update Pricing Module
- [ ] Support per-product pricing
- [ ] Support per-group pricing
- [ ] Remove tax-related pricing
- [ ] Update price list logic

### 2.9 Add/Update Reports Module
- [ ] P&L Report
- [ ] Daily Sales Report
- [ ] Discounts Report
- [ ] Total Daily Sales
- [ ] Today Sales
- [ ] Fast Moving Products
- [ ] Pending Orders
- [ ] Payment Method Reports (Cash/Card/Mpesa)
- [ ] Returns Report
- [ ] Out of Stock Items
- [ ] In-Store Items
- [ ] Low Stock Items
- [ ] Remove tax reports

### 2.10 Add Label Printing Service
- [ ] UUID generation service (for FG products only)
- [ ] QR code generation service
- [ ] ZPL template engine
- [ ] Print service (Network/USB)
- [ ] Print queue management

## Phase 3: Frontend Updates ⏳ PENDING

### 3.1 Remove Customer Registration UI
- [ ] Remove customer registration pages
- [ ] Remove customer management pages (or simplify)
- [ ] Update POS to remove customer selection

### 3.2 Remove Tax UI
- [ ] Remove tax configuration pages
- [ ] Remove tax fields from forms
- [ ] Remove tax columns from tables/reports

### 3.3 Update BOM Forms
- [ ] Restructure BOM creation form (Category, Type, Product)
- [ ] Support multiple RM items: Fabric, Buttons, Zipper, Lining, Elastic
- [ ] Update BOM validation
- [ ] Update BOM list/display

### 3.4 Update POS/Sales UI
- [ ] Remove customer selection
- [ ] Remove tax display
- [ ] Update payment methods (Cash/Card/Mpesa, default Cash)
- [ ] Update sales totals (remove VAT)

### 3.5 Update Reports UI
- [ ] Add new report pages (P&L, Daily Sales, etc.)
- [ ] Remove tax reports
- [ ] Update existing reports to remove tax columns

### 3.6 Add Label Printing UI
- [ ] Label print interface
- [ ] ZPL template configuration
- [ ] Print queue management
- [ ] Print button for FG products only

## Phase 4: Testing & Validation ⏳ PENDING
- [ ] Test all modules
- [ ] Validate BOM structure
- [ ] Test label printing
- [ ] Test reports
- [ ] End-to-end testing
- [ ] Performance testing

---

## Notes
- Keep RESTRUCTURING_PLAN.md as the master plan
- Update this file as tasks are completed
- Phase 1 is complete ✅
- Phase 2 is next priority 🔄
