/**
 * Jest Test Setup File
 * Runs before all tests
 * IMPORTANT: Set NODE_ENV first before any modules are loaded
 */

// Set test environment FIRST (before loading any other modules)
process.env.NODE_ENV = 'test';

// Load environment variables for testing (if .env.test exists)
try {
  require('dotenv').config({ path: '.env.test' });
} catch (error) {
  // Ignore if .env.test doesn't exist
}

// Increase timeout for database operations
jest.setTimeout(10000);

// Global test utilities or mocks can be added here
