/**
 * Seed Users Script
 * Creates default users (admin, manager, cashier)
 * 
 * Usage: node server/scripts/seed-users.js
 */

// Load environment variables
require('dotenv').config();

// Import database models
const db = require('../models');
// Import user seeder
const seedUsers = require('./seeders/seedUsers');
// Import logger
const logger = require('../utils/logger');

/**
 * Main function to seed users
 */
const runUserSeeder = async () => {
  try {
    // Connect to database
    await db.sequelize.authenticate();
    logger.info('✅ Database connection established for user seeding.');
    
    // Run user seeder
    logger.info('🌱 Starting user seeding...');
    await seedUsers(db);
    logger.info('✅ User seeding completed!');
    
    // Close database connection
    await db.sequelize.close();
    logger.info('✅ Database connection closed.');
    
    // Exit process
    process.exit(0);
  } catch (error) {
    // Log error and exit with error code
    logger.error('❌ User seeding failed:', error);
    console.error('Error details:', error);
    process.exit(1);
  }
};

// Run seeder if script is executed directly
if (require.main === module) {
  runUserSeeder();
}

// Export for use in other scripts
module.exports = runUserSeeder;
