# Database Migrations

This directory contains SQL migration scripts for database schema changes.

## How to Run Migrations

### Option 1: Using MySQL Command Line

```bash
# Connect to MySQL
mysql -u root -p

# Select your database
USE xyz_pos_db;

# Run the migration
source server/scripts/migrations/001_add_po_items_and_grn_processed_at.sql;

# Or from command line:
mysql -u root -p xyz_pos_db < server/scripts/migrations/001_add_po_items_and_grn_processed_at.sql
```

### Option 2: Using MySQL Workbench / phpMyAdmin

1. Open MySQL Workbench or phpMyAdmin
2. Select your database (`xyz_pos_db`)
3. Open the SQL file and execute it

### Option 3: Temporarily Enable Sequelize Alter

If you're in development and can afford to lose data, you can temporarily enable `alter: true` in `server/index.js`:

```javascript
await db.sequelize.sync({ alter: true });
```

Then restart the server. This will automatically add the `processed_at` column and create the `purchase_order_items` table.

**⚠️ WARNING:** Using `alter: true` can be risky in production. Always backup your database first!

## Migration Files

### 001_add_po_items_and_grn_processed_at.sql
- Creates `purchase_order_items` table
- Adds `processed_at` column to `grns` table

## Migration Naming Convention

Use the format: `XXX_description.sql` where:
- `XXX` = Sequential number (001, 002, 003, etc.)
- `description` = Brief description of what the migration does

## Notes

- Migrations are idempotent where possible (uses `CREATE TABLE IF NOT EXISTS` and checks for column existence)
- Always test migrations on a backup/staging database first
- Keep migrations sequential and don't skip numbers
- Document any breaking changes in migration comments

