/**
 * Production Services
 * Main export for all production services
 */

// Import BOM service
const bomService = require('./boms');
// Import production order service
const productionOrderService = require('./productionOrders');

// Export all production services
module.exports = {
  // BOM services
  createBOM: bomService.createBOM,
  getBOM: bomService.getBOM,
  getBOMByProduct: bomService.getBOMByProduct, // Variants removed - using getBOMByProduct
  getBOMByVariant: bomService.getBOMByVariant, // Deprecated - kept for backward compatibility during migration
  updateBOM: bomService.updateBOM,
  deleteBOM: bomService.deleteBOM,
  listBOMs: bomService.listBOMs,
  validateBOMFeasibility: bomService.validateBOMFeasibility,
  getBOMDimensionRequirements: bomService.getBOMDimensionRequirements,
  validateMixedBOM: bomService.validateMixedBOM,
  allocateMaterialsForBOM: bomService.allocateMaterialsForBOM,
  scaleBOMRequirements: bomService.scaleBOMRequirements,
  // Production order services
  createProductionOrder: productionOrderService.createProductionOrder,
  getProductionOrder: productionOrderService.getProductionOrder,
  listProductionOrders: productionOrderService.listProductionOrders,
  checkAvailability: productionOrderService.checkAvailability,
  confirmProduction: productionOrderService.confirmProduction,
};
