/**
 * Pricing Services
 * Main export for all pricing services
 */

// Import price list service
const priceListService = require('./priceLists');
// Import product price service
const productPriceService = require('./productPrices');

// Export all pricing services
module.exports = {
  // Price list services
  createPriceList: priceListService.createPriceList,
  getPriceList: priceListService.getPriceList,
  updatePriceList: priceListService.updatePriceList,
  deletePriceList: priceListService.deletePriceList,
  listPriceLists: priceListService.listPriceLists,
  getDefaultPriceList: priceListService.getDefaultPriceList,
  // Product price services
  createProductPrice: productPriceService.createProductPrice,
  getProductPrice: productPriceService.getProductPrice,
  updateProductPrice: productPriceService.updateProductPrice,
  deleteProductPrice: productPriceService.deleteProductPrice,
  listProductPrices: productPriceService.listProductPrices,
  getPrice: productPriceService.getPrice,
  getPriceForCustomer: productPriceService.getPriceForCustomer,
};

