/**
 * Validation Middleware
 * Validates request data using express-validator
 */

// Import express-validator validation result checker
const { validationResult } = require('express-validator');
// Import response utility
const response = require('../utils/response');

/**
 * Validation result checker middleware
 * Checks validation results and returns errors if validation fails
 * @param {Object} req - Express request object
 * @param {Object} res - Express response object
 * @param {Function} next - Express next middleware function
 */
const validate = (req, res, next) => {
  // Get validation errors from request
  const errors = validationResult(req);
  
  // If validation errors exist
  if (!errors.isEmpty()) {
    // Return validation error response
    return response.validationError(res, errors.array());
  }
  
  // If no errors, proceed to next middleware
  next();
};

// Export validation middleware
module.exports = validate;

