/**
 * Async Handler Middleware
 * Wraps async route handlers to automatically catch errors
 */

/**
 * Wraps an async function to catch errors and pass them to error handler
 * @param {Function} fn - Async function to wrap
 * @returns {Function} Wrapped function
 */
const asyncHandler = (fn) => {
  // Return a new function that handles async errors
  return (req, res, next) => {
    // Execute the async function and catch any errors
    Promise.resolve(fn(req, res, next)).catch(next); // Pass errors to Express error handler
  };
};

// Export async handler wrapper
module.exports = asyncHandler;

