/**
 * Jest Testing Configuration
 * Configuration for unit and integration tests
 */

module.exports = {
  // Test environment (Node.js)
  testEnvironment: 'node',
  
  // Root directory for tests
  roots: ['<rootDir>/tests'],
  
  // Test file patterns
  testMatch: [
    '**/__tests__/**/*.js',
    '**/?(*.)+(spec|test).js'
  ],
  
  // Coverage configuration
  collectCoverageFrom: [
    '**/*.js',
    '!**/node_modules/**',
    '!**/tests/**',
    '!**/coverage/**',
    '!**/scripts/**',
    '!**/jest.config.js',
    '!**/index.js'
  ],
  
  // Coverage thresholds
  coverageThreshold: {
    global: {
      branches: 50, // Minimum branch coverage percentage
      functions: 50, // Minimum function coverage percentage
      lines: 50, // Minimum line coverage percentage
      statements: 50 // Minimum statement coverage percentage
    }
  },
  
  // Coverage directory
  coverageDirectory: 'coverage',
  
  // Setup files (run before each test file)
  setupFiles: ['<rootDir>/tests/setup.js'],
  
  // Module paths
  moduleDirectories: ['node_modules', '<rootDir>'],
  
  // Clear mocks between tests
  clearMocks: true,
  
  // Restore mocks after each test
  restoreMocks: true,
  
  // Verbose output
  verbose: true,
  
  // Test timeout (30 seconds for property tests)
  testTimeout: 30000,
};

