/**
 * Database Configuration
 * Handles database connection setup and configuration
 */

// Load environment variables
require('dotenv').config();

// Database configuration object
const dbConfig = {
  // Development environment configuration
  development: {
    username: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'xyz_pos_db',
    host: process.env.DB_HOST || 'localhost',
    port: process.env.DB_PORT || 3306,
    dialect: process.env.DB_DIALECT || 'mysql',
    // Connection pool settings
    pool: {
      max: 5, // Maximum number of connections in pool
      min: 0, // Minimum number of connections in pool
      acquire: 30000, // Maximum time to wait for connection (ms)
      idle: 10000, // Maximum time connection can be idle (ms)
    },
    // Logging configuration
    logging: process.env.DB_LOGGING === 'true' ? console.log : false,
  },
  // Test environment configuration
  test: {
    username: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME|| 'xyz_pos_db_test',
    host: process.env.DB_HOST || 'localhost',
    port: process.env.DB_PORT || 3306,
    dialect: process.env.DB_DIALECT || 'mysql',
    logging: false, // Disable logging in test environment
  },
  // Production environment configuration
  production: {
    username: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    database: process.env.DB_NAME,
    host: process.env.DB_HOST,
    port: process.env.DB_PORT || 3306,
    dialect: process.env.DB_DIALECT || 'mysql',
    // Connection pool settings for production
    pool: {
      max: 20, // Higher connection pool for production
      min: 5,
      acquire: 30000,
      idle: 10000,
    },
    // Disable SQL query logging in production for security
    logging: false,
  },
};

// Export the configuration for the current environment
module.exports = dbConfig;

