@echo off
REM Build script for XYZ POS Print Service
REM This script builds the Windows executable

echo.
echo ========================================
echo   Building XYZ POS Print Service
echo ========================================
echo.

REM Check if Node.js is installed
where node >nul 2>nul
if %ERRORLEVEL% NEQ 0 (
    echo ERROR: Node.js is not installed or not in PATH
    echo Please install Node.js from https://nodejs.org/
    pause
    exit /b 1
)

REM Install dependencies
echo Installing dependencies...
call npm install
if %ERRORLEVEL% NEQ 0 (
    echo ERROR: Failed to install dependencies
    pause
    exit /b 1
)

REM Build the executable
echo.
echo Building Windows executable...
echo.
call npm run build:win

if %ERRORLEVEL% NEQ 0 (
    echo ERROR: Build failed
    pause
    exit /b 1
)

echo.
echo ========================================
echo   Build Complete!
echo ========================================
echo.
echo The executable is in the 'dist' directory:
echo   dist\xyz-pos-print-service.exe
echo.
echo You can run it directly - no Node.js needed!
echo.

pause
