# Installation Guide - XYZ POS Print Service

## Quick Installation (Using Pre-built .exe)

### First: Build the Executable

**You need to build the .exe file first** (see `BUILD.md` for detailed instructions):

1. **Install Node.js** (if not already installed)
   - Download from [https://nodejs.org/](https://nodejs.org/)
   - Install the LTS version

2. **Build the executable:**
   ```bash
   cd local-print-service
   npm install
   npm run build:win
   ```
   
   Or simply double-click `build.bat` in the `local-print-service` folder

3. **Find the .exe:**
   - Located in: `dist/xyz-pos-print-service.exe`
   - This is your standalone executable!

### Then: Install and Run

1. **Copy the executable**
   - Copy `dist/xyz-pos-print-service.exe` to a folder (e.g., `C:\Program Files\XYZPOS\PrintService\`)

2. **Run the service**
   - Double-click `xyz-pos-print-service.exe`
   - A console window will appear showing the service status
   - The service runs on `http://localhost:9101`

3. **Verify it's working**
   - Open browser: `http://localhost:9101/health`
   - You should see: `{"status":"ok","service":"xyz-pos-print-service"}`

4. **Access from web app**
   - The web application will automatically detect the service
   - No configuration needed!

**Note:** If you can't build the .exe, you can also run from source (see "Build from Source" section below).

## Build from Source

### Prerequisites

- **Node.js 18 or higher** - Download from [nodejs.org](https://nodejs.org/)
- **npm** (comes with Node.js)

### Steps

1. **Open Command Prompt** in the `local-print-service` folder

2. **Install dependencies:**
   ```bash
   npm install
   ```

3. **Build the executable:**
   ```bash
   npm run build:win
   ```
   
   Or use the batch file:
   ```bash
   build.bat
   ```

4. **Find the .exe:**
   - The executable will be in `dist/` directory
   - File: `dist/xyz-pos-print-service.exe`

5. **Run the executable:**
   - Double-click `xyz-pos-print-service.exe`
   - Or use `start.bat` to run from source

## Run on Startup (Optional)

### Method 1: Task Scheduler (Recommended)

1. Open **Task Scheduler** (search in Windows Start menu)
2. Click **Create Basic Task**
3. Name: `XYZ POS Print Service`
4. Trigger: **When the computer starts**
5. Action: **Start a program**
6. Browse to: `C:\path\to\xyz-pos-print-service.exe`
7. Click **Finish**

The service will now start automatically on Windows boot.

### Method 2: Startup Folder

1. Press `Win + R`
2. Type: `shell:startup`
3. Press Enter
4. Create a shortcut to `xyz-pos-print-service.exe` in this folder

### Method 3: Windows Service (Advanced)

Use **NSSM** (Non-Sucking Service Manager):

1. Download NSSM from [nssm.cc](https://nssm.cc/download)
2. Extract to a folder
3. Open Command Prompt as Administrator:
   ```bash
   nssm install XYZPOSPrintService "C:\path\to\xyz-pos-print-service.exe"
   nssm start XYZPOSPrintService
   ```

The service will run as a Windows service in the background.

## Troubleshooting

### Service won't start

1. **Check port 9101:**
   ```powershell
   netstat -ano | findstr :9101
   ```
   If port is in use, change it by setting environment variable:
   ```bash
   set PORT=9102
   xyz-pos-print-service.exe
   ```

2. **Run as Administrator:**
   - Right-click `.exe` → **Run as administrator**

3. **Check Windows Firewall:**
   - Allow port 9101 if prompted

### No printers detected

1. **Verify printer drivers:**
   - Open Windows Settings → Devices → Printers & scanners
   - Ensure your printer is listed and not offline

2. **Check printer name:**
   - The name must match exactly (case-sensitive)

### Print fails

1. **Check printer status:**
   - Ensure printer is not paused or offline
   - Check printer has paper

2. **Try running as Administrator:**
   - Some printers require admin rights

3. **Check Windows Event Viewer:**
   - Search for "printer" errors

### Web app can't connect

1. **Test service endpoint:**
   - Open: `http://localhost:9101/health`
   - Should return: `{"status":"ok"}`

2. **Check browser console:**
   - Look for connection errors
   - CORS errors should be handled automatically

3. **Verify service is running:**
   - Check if console window is open
   - Should see: "Service running on http://localhost:9101"

## Configuration

### Change Port

Edit the service or set environment variable:

```bash
set PORT=9102
xyz-pos-print-service.exe
```

### Change Host

```bash
set HOST=0.0.0.0
xyz-pos-print-service.exe
```

This allows access from other devices on the network.

## Uninstallation

1. **Stop the service:**
   - Close the console window if running manually
   - Or stop from Task Scheduler if configured

2. **Delete files:**
   - Delete the `.exe` file and folder

3. **Remove from startup (if added):**
   - Remove from Task Scheduler
   - Or remove shortcut from Startup folder

## Support

For issues or questions:
- Check `README.md` for API documentation
- Check `PRINTER_EXPLANATION.md` for why label printers need special handling
- Review Windows Event Viewer for errors
