# How to Build the Executable (.exe)

## Prerequisites

1. **Node.js 18 or higher** - Download from [https://nodejs.org/](https://nodejs.org/)
   - Download the LTS version (recommended)
   - Install it (includes npm)

2. **Internet connection** (for downloading dependencies)

## Step-by-Step Build Instructions

### On Windows:

1. **Open Command Prompt or PowerShell** in the `local-print-service` folder

   - Navigate to the folder:
     ```bash
     cd path\to\xyz_pos\local-print-service
     ```

2. **Install dependencies:**
   ```bash
   npm install
   ```
   
   This will install:
   - `pkg` - Tool to create executables
   - `cors` - CORS support

3. **Build the executable:**

   **Option A: Using the batch file (Easiest)**
   ```bash
   build.bat
   ```

   **Option B: Using npm command**
   ```bash
   npm run build:win
   ```

4. **Find your .exe file:**
   - Go to the `dist` folder
   - You'll find: `xyz-pos-print-service.exe`
   - This is your standalone executable!

5. **Test it:**
   - Double-click `dist/xyz-pos-print-service.exe`
   - Should see a console window with service status
   - Open browser: `http://localhost:9101/health`

## Build Output

After building, you'll have:

```
dist/
└── xyz-pos-print-service.exe    ← This is what you need!
```

## What Gets Built

The `pkg` tool packages:
- Node.js runtime
- All dependencies
- Your service code

Into a **single standalone .exe file** that:
- ✅ Works without Node.js installed
- ✅ Works without npm
- ✅ Just double-click and run!

## Troubleshooting

### Error: "npm is not recognized"

**Solution:** Node.js is not installed or not in PATH
1. Install Node.js from [nodejs.org](https://nodejs.org/)
2. Restart Command Prompt
3. Verify: `node --version` should work

### Error: "pkg command not found"

**Solution:** Dependencies not installed
```bash
npm install
```

### Build fails with "ENOENT" errors

**Solution:** Make sure you're in the correct directory
```bash
cd local-print-service
npm install
npm run build:win
```

### Build is slow

**Normal:** First build downloads Node.js binaries (50-100MB)
- Subsequent builds are faster
- Be patient, it's creating a complete executable

## File Size

The .exe file will be approximately:
- **~50-80 MB** (includes Node.js runtime)
- This is normal for standalone executables

## Distribution

Once built, you can:
1. Copy `dist/xyz-pos-print-service.exe` to any Windows machine
2. Run it directly - **no installation needed**
3. No Node.js required on target machine
4. Works on Windows 7/8/10/11

## Alternative: Pre-built Release

If you can't build it yourself, you can:
1. Ask someone with Node.js to build it for you
2. Use the source code version (`npm start`) if Node.js is installed
3. Check for pre-built releases in the project repository

## Next Steps

After building:
1. Copy `xyz-pos-print-service.exe` to desired location
2. Run it to test
3. See `INSTALL.md` for setup instructions
4. Add to Windows startup (optional)
