# Testing Setup Guide

## Port Configuration

- **Backend Server**: Port 4000
- **Frontend Client**: Port 3000

## Configuration Files

### Backend (.env)
Located at: `server/.env`
```
PORT=4000
```

### Frontend (.env.local)
Located at: `client/.env.local`
```
NEXT_PUBLIC_API_URL=http://localhost:4000/api
```

## Starting the Servers

### 1. Start Backend Server
```bash
cd server
npm start
# Server will run on http://localhost:4000
```

### 2. Start Frontend Client
```bash
cd client
npm run dev
# Frontend will run on http://localhost:3000
```

## Testing the Application

1. **Access Frontend**: Open http://localhost:3000 in your browser
2. **Login**: Use your admin credentials (or setup if first time)
3. **Test POS**: Navigate to POS section and test the interface
4. **Test Dashboard**: Check the dashboard overview

## API Endpoints

- Backend API: http://localhost:4000/api
- Frontend: http://localhost:3000

## Troubleshooting

- If backend doesn't start, check `server/.env` has `PORT=4000`
- If frontend can't connect, check `client/.env.local` has correct API URL
- Check logs: Backend logs in console, Frontend logs in browser console
- Make sure database is running and accessible

