# Model Update Plan - Restructuring

To create the database from scratch with models that match our restructuring requirements, we need to update the models FIRST, then sync the database.

## Models to UPDATE

### 1. Remove ProductVariant References

**Models that need variant_id removed:**
- `Product.js` - Remove variant relationships
- `SaleItem.js` - Remove variant_id field
- `Inventory.js` - Remove variant_id field
- `InventoryItem.js` - Remove variant_id field
- `InventoryMovement.js` - Remove variant_id field
- `ProductPrice.js` - Remove variant_id field
- `GRNItem.js` - Remove variant_id field
- `PurchaseOrderItem.js` - Remove variant_id field
- `BOM.js` - Change fg_variant_id to fg_product_id
- `ProductionOrder.js` - Change fg_variant_id to fg_product_id
- `index.js` - Remove ProductVariant model import

### 2. Remove Tax References

**Models to update:**
- `Product.js` - Remove tax_category_id, default_vat_rate fields
- `Sale.js` - Remove vat field
- `SaleItem.js` - Remove vat_rate, vat_amount fields
- `index.js` - Remove TaxCategory, TaxRate, TaxExemption model imports

**Models to DELETE:**
- `TaxCategory.js`
- `TaxRate.js`
- `TaxExemption.js`

### 3. Add New Fields

**Models to update:**
- `Product.js` - Add low_stock_threshold field

### 4. Update Payment Model

**Models to update:**
- `Payment.js` - Update provider enum from ('PAYSTACK', 'CASH', 'MOBILE', 'BANK') to ('CASH', 'CARD', 'MPESA')

## Approach

Since this is extensive, we have two options:

### Option A: Update Models First (Recommended)
1. Update all models to remove variants, tax, add new fields
2. Sync database from updated models
3. Database will be created with correct schema from the start

### Option B: Sync from Current Models, Then Migrate
1. Sync database from current models (creates all tables)
2. Run migrations to modify schema
3. More complex but preserves migration history

## Recommendation

**Option A** is cleaner for a fresh start - update models first, then sync. This ensures models and database are always in sync.
