# GitHub Secrets Reference

Add these in **Settings → Secrets and variables → Actions** for CI/CD to work.

---

## Required secrets (copy-paste checklist)

| Secret name | Value type | Notes |
|-------------|------------|-------|
| `NAMECHEAP_SSH_HOST` | `"vps123.namecheap.com"` or `"123.45.67.89"` | VPS hostname or IP |
| `NAMECHEAP_SSH_USER` | `"root"` or `"deploy"` | SSH username |
| `NAMECHEAP_SSH_KEY` | `-----BEGIN OPENSSH PRIVATE KEY-----...` | Full private key content |
| `NAMECHEAP_SSH_PORT` | `"22"` | Default SSH port; use `"21098"` for shared hosting |
| `NAMECHEAP_DEPLOY_PATH` | `"/opt/xyz-pos"` | Path where repo is cloned on VPS |
| `GHCR_TOKEN` | `ghp_xxxxxxxx` | GitHub PAT with `read:packages` |
| `NAMECHEAP_GHCR_USER` | `"your-github-username"` | Same as repo owner |
| `NEXT_PUBLIC_API_URL` | `"https://api.yourdomain.com/api"` | Full API URL for frontend |

---

## Optional (frontend build args)

| Secret name | Default | Notes |
|-------------|---------|-------|
| `NEXT_PUBLIC_PRINT_SERVICE_URL` | `http://127.0.0.1:9101` | Local PrintService URL |
| `NEXT_PUBLIC_PRINT_SERVICE_KEY` | `xyz-pos-local-token` | PrintService API key |

---

## Server environment (on VPS, not GitHub)

Create `server/.env.production` on the VPS with:

```env
NODE_ENV=production
HOST=0.0.0.0
PORT=4000
JWT_SECRET="..."
JWT_EXPIRES_IN=24h
JWT_REFRESH_EXPIRES_IN=7d
DB_HOST="..."
DB_USER="..."
DB_PASSWORD="..."
DB_NAME="xyz_pos_db"
DB_LOGGING=false
PAYSTACK_SECRET_KEY=""
PAYSTACK_PUBLIC_KEY=""
CORS_ORIGIN="https://your-domain.com"
# ... see server/.env.production.example
```

---

## Creating a GitHub PAT for GHCR_TOKEN

1. GitHub → Settings → Developer settings → Personal access tokens
2. Generate new token (classic)
3. Scope: `read:packages`
4. Copy token and add as `GHCR_TOKEN` secret
