/**
 * Returns API endpoints
 */

import apiClient from './client';
import { API_ENDPOINTS } from '@/config/api';

export const returnsAPI = {
  /**
   * List returns
   * @param {Object} params - Query parameters
   * @returns {Promise}
   */
  list: async (params = {}) => {
    return apiClient.get(API_ENDPOINTS.RETURNS, { params });
  },

  /**
   * Get return by ID
   * @param {number} id
   * @returns {Promise}
   */
  getById: async (id) => {
    return apiClient.get(`${API_ENDPOINTS.RETURNS}/${id}`);
  },

  /**
   * Create return
   * @param {Object} returnData
   * @returns {Promise}
   */
  create: async (returnData) => {
    return apiClient.post(API_ENDPOINTS.RETURNS, returnData);
  },

  /**
   * Complete return
   * @param {number} id
   * @param {Object} refundData - Refund information (refund_method, refund_amount, replacement_product_id, refund_reference)
   * @returns {Promise}
   */
  complete: async (id, refundData = {}) => {
    return apiClient.post(`${API_ENDPOINTS.RETURNS}/${id}/complete`, refundData);
  },
};

