/**
 * Reports API endpoints
 */

import apiClient from './client';
import { API_ENDPOINTS } from '@/config/api';

export const reportsAPI = {
  /**
   * Get sales report by date range
   * @param {Object} params - Query parameters (start_date, end_date, payment_provider)
   * @returns {Promise}
   */
  getSalesReportByDate: async (params = {}) => {
    return apiClient.get(`${API_ENDPOINTS.REPORTS}/sales/date`, { params });
  },

  /**
   * Get sales report by product
   * @param {Object} params - Query parameters (start_date, end_date, product_id)
   * @returns {Promise}
   */
  getSalesReportByProduct: async (params = {}) => {
    return apiClient.get(`${API_ENDPOINTS.REPORTS}/sales/product`, { params });
  },

  /**
   * Get sales report by cashier
   * @param {Object} params - Query parameters (start_date, end_date, user_id)
   * @returns {Promise}
   */
  getSalesReportByCashier: async (params = {}) => {
    return apiClient.get(`${API_ENDPOINTS.REPORTS}/sales/cashier`, { params });
  },

  /**
   * Get profit & loss report
   * @param {Object} params - Query parameters (start_date, end_date)
   * @returns {Promise}
   */
  getProfitLossReport: async (params = {}) => {
    return apiClient.get(`${API_ENDPOINTS.REPORTS}/financial/profit-loss`, { params });
  },

  /**
   * Get fast moving products report
   * @param {Object} params - Query parameters (start_date, end_date, limit)
   * @returns {Promise}
   */
  getFastMovingProducts: async (params = {}) => {
    return apiClient.get(`${API_ENDPOINTS.REPORTS}/inventory/fast-moving`, { params });
  },

  /**
   * Get low stock items report
   * @param {Object} params - Query parameters (category_id)
   * @returns {Promise}
   */
  getLowStockItems: async (params = {}) => {
    return apiClient.get(`${API_ENDPOINTS.REPORTS}/inventory/low-stock`, { params });
  },

  /**
   * Get payment methods report
   * @param {Object} params - Query parameters (start_date, end_date, provider)
   * @returns {Promise}
   */
  getPaymentMethodsReport: async (params = {}) => {
    return apiClient.get(`${API_ENDPOINTS.REPORTS}/payment-methods`, { params });
  },

  /**
   * Get slow moving products report
   * @param {Object} params - Query parameters (start_date, end_date, limit)
   * @returns {Promise}
   */
  getSlowMovingProducts: async (params = {}) => {
    return apiClient.get(`${API_ENDPOINTS.REPORTS}/inventory/slow-moving`, { params });
  },
};

