/**
 * Payments API endpoints
 */

import apiClient from './client';
import { API_ENDPOINTS } from '@/config/api';

export const paymentsAPI = {
  /**
   * Create payment
   * @param {Object} paymentData
   * @returns {Promise}
   */
  create: async (paymentData) => {
    return apiClient.post(API_ENDPOINTS.PAYMENTS, paymentData);
  },

  /**
   * Get payments for sale
   * @param {number} saleId
   * @returns {Promise}
   */
  getBySale: async (saleId) => {
    return apiClient.get(`${API_ENDPOINTS.PAYMENTS}/sale/${saleId}`);
  },

  /**
   * Query M-Pesa STK Push status
   * @param {string} checkoutRequestID
   * @returns {Promise}
   */
  querySTKPushStatus: async (checkoutRequestID) => {
    return apiClient.get(`${API_ENDPOINTS.PAYMENTS}/mpesa/query/${checkoutRequestID}`);
  },

  /**
   * Manually confirm M-Pesa payment (manager/admin only)
   * @param {Object} data - { payment_id, mpesa_transaction_code }
   * @returns {Promise}
   */
  manuallyConfirm: async (data) => {
    return apiClient.post(`${API_ENDPOINTS.PAYMENTS}/mpesa/manual-confirm`, data);
  },
};

