/**
 * Authentication API endpoints
 */

import apiClient from './client';
import { API_ENDPOINTS } from '@/config/api';

export const authAPI = {
  /**
   * Login with username and password
   * @param {string} username
   * @param {string} password
   * @returns {Promise}
   */
  login: async (username, password) => {
    return apiClient.post(API_ENDPOINTS.AUTH.LOGIN, {
      username,
      password,
    });
  },

  /**
   * Login with PIN code
   * @param {string} username
   * @param {string} pinCode
   * @returns {Promise}
   */
  loginWithPin: async (username, pinCode) => {
    return apiClient.post(API_ENDPOINTS.AUTH.LOGIN_WITH_PIN, {
      username,
      pin_code: pinCode,
    });
  },

  /**
   * System setup (first time setup)
   * @param {Object} setupData
   * @returns {Promise}
   */
  setup: async (setupData) => {
    return apiClient.post(API_ENDPOINTS.AUTH.SETUP, setupData);
  },

  /**
   * Get current user profile
   * @returns {Promise}
   */
  getProfile: async () => {
    return apiClient.get(API_ENDPOINTS.AUTH.PROFILE);
  },

  /**
   * Logout (client-side - clears token)
   */
  logout: () => {
    if (typeof window !== 'undefined') {
      localStorage.removeItem('token');
      localStorage.removeItem('user');
    }
  },
};

