/**
 * Table Component
 * Pure Tailwind CSS - Clean data tables
 */

'use client';

export default function Table({ children, className = '' }) {
  return (
    <div className={`overflow-x-auto rounded-lg border border-gray-200 dark:border-gray-700 ${className}`}>
      <div className="inline-block min-w-full align-middle">
        <table className="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
          {children}
        </table>
      </div>
    </div>
  );
}

export function TableHeader({ children, className = '' }) {
  return (
    <thead
      className={`bg-gray-50 dark:bg-gray-800/50 ${className}`}
    >
      {children}
    </thead>
  );
}

export function TableBody({ children, className = '', striped = false }) {
  return (
    <tbody
      className={`divide-y divide-gray-200 dark:divide-gray-700 bg-white dark:bg-gray-800 ${
        striped
          ? '[&_tr:nth-child(even)]:bg-gray-50 dark:[&_tr:nth-child(even)]:bg-gray-800/30'
          : ''
      } ${className}`}
    >
      {children}
    </tbody>
  );
}

export function TableRow({
  children,
  className = '',
  onClick,
  hoverable = true,
}) {
  return (
    <tr
      className={`
        transition-colors duration-150
        ${
          onClick || hoverable
            ? 'hover:bg-gray-50 dark:hover:bg-gray-700/50 cursor-pointer'
            : ''
        }
        ${onClick ? 'active:bg-gray-100 dark:active:bg-gray-700' : ''}
        ${className}
      `}
      onClick={onClick}
    >
      {children}
    </tr>
  );
}

export function TableHead({
  children,
  className = '',
  align = 'left',
  sortable = false,
}) {
  const alignClass = {
    left: 'text-left',
    center: 'text-center',
    right: 'text-right',
  }[align];

  return (
    <th
      className={`
        px-6 py-3 text-xs font-semibold uppercase tracking-wider
        text-gray-700 dark:text-gray-300
        ${sortable ? 'cursor-pointer select-none hover:text-gray-900 dark:hover:text-gray-100' : ''}
        transition-colors duration-150
        ${alignClass}
        ${className}
      `}
    >
      {children}
    </th>
  );
}

export function TableCell({ children, className = '', align = 'left' }) {
  const alignClass = {
    left: 'text-left',
    center: 'text-center',
    right: 'text-right',
  }[align];

  return (
    <td
      className={`
        px-6 py-4 whitespace-nowrap text-sm
        text-gray-900 dark:text-gray-100
        ${alignClass}
        ${className}
      `}
    >
      {children}
    </td>
  );
}
