# UI Components

Reusable UI components for the XYZ POS application.

## Components

### Button
Primary button component with multiple variants and sizes.

```jsx
import { Button } from '@/components/ui';

<Button variant="primary" size="md">Click Me</Button>
<Button variant="danger" loading={true}>Delete</Button>
```

**Props:**
- `variant`: 'primary' | 'secondary' | 'success' | 'danger' | 'outline' | 'ghost'
- `size`: 'sm' | 'md' | 'lg' | 'xl'
- `loading`: boolean
- `disabled`: boolean

### Input
Form input field with label and error display.

```jsx
import { Input } from '@/components/ui';

<Input
  label="Username"
  name="username"
  value={value}
  onChange={onChange}
  error={error}
  required
/>
```

### Select
Dropdown select component.

```jsx
import { Select } from '@/components/ui';

<Select
  label="Status"
  name="status"
  options={[
    { value: 'active', label: 'Active' },
    { value: 'inactive', label: 'Inactive' }
  ]}
  value={value}
  onChange={onChange}
/>
```

### Textarea
Textarea input component.

```jsx
import { Textarea } from '@/components/ui';

<Textarea
  label="Description"
  name="description"
  rows={4}
  value={value}
  onChange={onChange}
/>
```

### Card
Card container with header, content, and footer sections.

```jsx
import { Card, CardHeader, CardTitle, CardContent, CardFooter } from '@/components/ui';

<Card>
  <CardHeader>
    <CardTitle>Card Title</CardTitle>
  </CardHeader>
  <CardContent>
    Card content goes here
  </CardContent>
  <CardFooter>
    Footer content
  </CardFooter>
</Card>
```

### Modal
Modal dialog component.

```jsx
import { Modal } from '@/components/ui';

<Modal
  isOpen={isOpen}
  onClose={() => setIsOpen(false)}
  title="Modal Title"
  size="md"
>
  Modal content
</Modal>
```

**Props:**
- `isOpen`: boolean
- `onClose`: function
- `title`: string
- `size`: 'sm' | 'md' | 'lg' | 'xl' | 'full'

### Loading
Loading spinner and loader components.

```jsx
import { LoadingSpinner, LoadingPage, LoadingOverlay } from '@/components/ui';

<LoadingSpinner size="md" />
<LoadingPage message="Loading data..." />
<LoadingOverlay message="Processing..." />
```

### Badge
Status badge component.

```jsx
import { Badge } from '@/components/ui';

<Badge variant="success" size="md">Active</Badge>
<Badge variant="danger">Inactive</Badge>
```

**Props:**
- `variant`: 'default' | 'primary' | 'success' | 'warning' | 'danger' | 'info'
- `size`: 'sm' | 'md' | 'lg'

