/**
 * Badge Component
 * Pure Tailwind CSS - Status badges
 */

export default function Badge({
  children,
  variant = 'default',
  size = 'md',
  pulse = false,
  dot = false,
  className = '',
}) {
  const baseStyles = [
    'inline-flex items-center font-medium rounded-full',
    'transition-colors duration-200',
  ].join(' ');

  const variants = {
    default: [
      'bg-gray-100 text-gray-800',
      'dark:bg-gray-700 dark:text-gray-200',
    ].join(' '),
    primary: [
      'bg-blue-100 text-blue-800',
      'dark:bg-blue-900/30 dark:text-blue-300',
    ].join(' '),
    success: [
      'bg-green-100 text-green-800',
      'dark:bg-green-900/30 dark:text-green-300',
    ].join(' '),
    warning: [
      'bg-yellow-100 text-yellow-800',
      'dark:bg-yellow-900/30 dark:text-yellow-300',
    ].join(' '),
    danger: [
      'bg-red-100 text-red-800',
      'dark:bg-red-900/30 dark:text-red-300',
    ].join(' '),
    info: [
      'bg-cyan-100 text-cyan-800',
      'dark:bg-cyan-900/30 dark:text-cyan-300',
    ].join(' '),
  };

  const sizes = {
    sm: 'px-2 py-0.5 text-xs gap-1',
    md: 'px-2.5 py-1 text-sm gap-1.5',
    lg: 'px-3 py-1.5 text-base gap-2',
  };

  const variantClass = variants[variant] || variants.default;
  const sizeClass = sizes[size] || sizes.md;
  const pulseClass = pulse ? 'animate-pulse' : '';

  return (
    <span
      className={`${baseStyles} ${variantClass} ${sizeClass} ${pulseClass} ${className}`}
    >
      {dot && (
        <span
          className={`w-1.5 h-1.5 rounded-full ${
            variant === 'primary'
              ? 'bg-blue-600 dark:bg-blue-400'
              : variant === 'success'
              ? 'bg-green-600 dark:bg-green-400'
              : variant === 'warning'
              ? 'bg-yellow-600 dark:bg-yellow-400'
              : variant === 'danger'
              ? 'bg-red-600 dark:bg-red-400'
              : variant === 'info'
              ? 'bg-cyan-600 dark:bg-cyan-400'
              : 'bg-gray-600 dark:bg-gray-400'
          }`}
        />
      )}
      {children}
    </span>
  );
}
