/**
 * Production Hub Page
 * Main production management hub
 */

'use client';

import { useRouter } from 'next/navigation';
import { Card, CardHeader, CardTitle, CardContent, Button } from '@/components/ui';
import { Package, FileText, Settings, ArrowRight } from 'lucide-react';

export default function ProductionPage() {
  const router = useRouter();

  const menuItems = [
    {
      title: 'BOMs',
      description: 'Manage Bill of Materials (BOMs) - recipes for finished goods',
      icon: FileText,
      href: '/production/boms',
      color: 'blue',
    },
    {
      title: 'Production Orders',
      description: 'Create and manage production orders',
      icon: Package,
      href: '/production/orders',
      color: 'green',
    },
  ];

  return (
    <div className="p-6 bg-gray-50 dark:bg-gray-950 space-y-6">
      {/* Header */}
      <div>
        <h1 className="text-3xl font-bold text-gray-900 dark:text-white">Production</h1>
        <p className="mt-1 text-sm text-gray-600 dark:text-gray-400">
          Manage production operations, BOMs, and production orders
        </p>
      </div>

      {/* Menu Cards */}
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        {menuItems.map((item) => {
          const Icon = item.icon;
          return (
            <Card
              key={item.href}
              className="hover:shadow-lg transition-shadow cursor-pointer"
              onClick={() => router.push(item.href)}
            >
              <CardHeader>
                <div className="flex items-center gap-4">
                  <div className={`p-3 rounded-lg bg-${item.color}-100 dark:bg-${item.color}-900`}>
                    <Icon className={`w-6 h-6 text-${item.color}-600 dark:text-${item.color}-400`} />
                  </div>
                  <CardTitle className="text-xl">{item.title}</CardTitle>
                </div>
              </CardHeader>
              <CardContent>
                <p className="text-sm text-gray-600 dark:text-gray-400 mb-4">{item.description}</p>
                <Button
                  variant="outline"
                  className="w-full flex items-center justify-center gap-2"
                  onClick={(e) => {
                    e.stopPropagation();
                    router.push(item.href);
                  }}
                >
                  Open <ArrowRight className="w-4 h-4" />
                </Button>
              </CardContent>
            </Card>
          );
        })}
      </div>
    </div>
  );
}

