# XYZ POS - Frontend

Frontend application for XYZ Point of Sale system built with Next.js.

## Getting Started

1. Install dependencies:
```bash
npm install
```

2. Set up environment variables:
```bash
cp .env.example .env.local
# Edit .env.local with your API URL
```

3. Run the development server:
```bash
npm run dev
```

4. Open [http://localhost:3001](http://localhost:3001) in your browser.

## Project Structure

See [FRONTEND_PLAN.md](./FRONTEND_PLAN.md) for detailed architecture and development plan.

## API Configuration

The frontend connects to the backend API. Default API URL is `http://localhost:3000/api`.

Set `NEXT_PUBLIC_API_URL` in `.env.local` to configure a different API endpoint.

## Development

- **Framework:** Next.js 16 (App Router)
- **Styling:** Tailwind CSS v4
- **Language:** JavaScript/React

## Available Scripts

- `npm run dev` - Start development server
- `npm run build` - Build for production
- `npm start` - Start production server
- `npm run lint` - Run ESLint
