@echo off
setlocal

set SERVICE_NAME=XYZ Print Service

REM Check for admin privileges
net session >nul 2>&1
if %errorlevel% neq 0 (
  echo ERROR: This script must be run as Administrator
  exit /b 1
)

echo Uninstalling "%SERVICE_NAME%"...

REM Stop service first
sc stop "%SERVICE_NAME%" >nul 2>&1
if %errorlevel% equ 0 (
  echo Service stopped, waiting...
  timeout /t 2 /nobreak >nul
)

REM Delete service
sc delete "%SERVICE_NAME%"
if %errorlevel% neq 0 (
  echo ERROR: Failed to delete service
  echo Service may not exist
  exit /b 1
)

echo.
echo ========================================
echo Service uninstalled successfully!
echo ========================================

endlocal
