@echo off
setlocal

set SERVICE_NAME=XYZ Print Service
set "SCRIPT_DIR=%~dp0"
set "PROJECT_ROOT=%SCRIPT_DIR%.."
set "EXE_PATH=%PROJECT_ROOT%\publish\XYZ.PrintService.exe"

echo ========================================
echo XYZ Print Service Status Check
echo ========================================
echo.

REM Check if EXE exists
echo [1] Checking executable...
if exist "%EXE_PATH%" (
    echo   [OK] Executable found: %EXE_PATH%
    for %%A in ("%EXE_PATH%") do echo   Size: %%~zA bytes
) else (
    echo   [MISSING] Executable not found: %EXE_PATH%
    echo   Run 'scripts\publish.bat' to build
)
echo.

REM Check if service is installed
echo [2] Checking service installation...
sc query "%SERVICE_NAME%" >nul 2>&1
if %errorlevel% equ 0 (
    echo   [OK] Service is installed
    sc query "%SERVICE_NAME%"
) else (
    echo   [NOT INSTALLED] Service is not installed
    echo   Run 'scripts\install-service.bat' as Administrator to install
)
echo.

REM Check if service is running
echo [3] Checking service status...
sc query "%SERVICE_NAME%" | findstr "RUNNING" >nul 2>&1
if %errorlevel% equ 0 (
    echo   [OK] Service is running
) else (
    echo   [STOPPED] Service is not running
    echo   Run 'scripts\start-service.bat' as Administrator to start
)
echo.

REM Test HTTP endpoint
echo [4] Testing HTTP endpoint...
curl -s http://127.0.0.1:9101/health >nul 2>&1
if %errorlevel% equ 0 (
    echo   [OK] Service is responding on http://127.0.0.1:9101
) else (
    echo   [FAILED] Service is not responding
    echo   Check if service is running and port 9101 is not blocked
)
echo.

echo ========================================
endlocal
pause
