using XYZ.PrintService.Api;
using XYZ.PrintService.Security;

var builder = WebApplication.CreateBuilder(args);

// Windows Service support
builder.Host.UseWindowsService();

// Bind strictly to localhost
builder.WebHost.UseUrls("http://127.0.0.1:9101");

// CORS for browser
builder.Services.AddCors(o =>
{
    o.AddDefaultPolicy(p =>
        p.AllowAnyHeader()
         .AllowAnyMethod()
         .AllowAnyOrigin());
});

var app = builder.Build();

app.UseCors();

// Optional API key protection
app.UseMiddleware<ApiKeyMiddleware>();

// Register endpoints
PrinterEndpoints.Map(app);

app.Run();
